//@author: antokhio
//@help: Glass shader with reflection and refractive dispersion.
//@tags: material, cubemap, glass, reflection, refraction, dispersion, fresnel
//@credits: dottore, nvidia

//StructuredBuffer<float4> color <bool color=true;>;

TextureCube texCube <string uiname = "Environment Texture";>;
//Texture2D texFresnel<string uiname = "Fresnel Texture";>; 
SamplerState s0:IMMUTABLE {Filter=MIN_MAG_MIP_LINEAR;AddressU=CLAMP;AddressV=CLAMP;};

float4x4 tW : WORLD;
float4x4 tVP : VIEWPROJECTION;
float4x4 tWVP : WORLDVIEWPROJECTION;
float4x4 tWIT : WORLDINVERSETRANSPOSE;
float4x4 tVI : VIEWINVERSE;

float reflectStrength <float uimin = 0.0; float uimax = 1.0; string uiname =  "Reflection";> = 0.5;
float refractStrength <float uimin = 0.0; float uimax = 1.0; string uiname =  "Refraction";> = 0.5;

float3 etas <string uiname = "Refraction indices";> = { 0.80, 0.82, 0.84 };

struct VS_IN
{
	float4 pos : POSITION;
	float4 normal : NORMAL;
	float4 uv : TEXCOORD0;
};

struct VS_OUT
{
    float4 pos: SV_POSITION;
    float4 uv: TEXCOORD0;
	float3 normal : TEXCOORD1;
	float3 worldview : TEXCOORD2;
};

VS_OUT VS(VS_IN input)
{
    VS_OUT output = (VS_OUT)0;
    
	output.pos = mul (input.pos,tWVP);
	output.uv = input.uv;
	
	float3 normal = normalize(input.normal.xyz);
	output.normal = mul (normal, (float3x3) tWIT);
	
	float3 Pw = mul (input.pos, tW).xyz;
	output.worldview = tVI[3].xyz - Pw;
	
    return output;
}

// modified refraction function that returns boolean for total internal reflection
float3 refract2( float3 I, float3 N, float eta, out bool fail )
{
	float IdotN = dot(I, N);
	float k = 1 - eta*eta*(1 - IdotN*IdotN);
//	return k < 0 ? (0,0,0) : eta*I - (eta*IdotN + sqrt(k))*N;
	fail = k < 0;
	return eta*I - (eta*IdotN + sqrt(k))*N;
}

// approximate Fresnel function
float ffresnel(float NdotV, float bias, float power)
{
   return bias + (1.0-bias)*pow(1.0 - max(NdotV, 0), power);
}

// function to generate a texture encoding the Fresnel function
float4 generateFresnelTex(float NdotV : POSITION) : COLOR
{
	return ffresnel(NdotV, 0.2, 4.0);
}

float4 PS(VS_OUT input): SV_Target
{
    float3 N = normalize(input.normal);
    float3 V = normalize(input.worldview);
    
 	// reflection
    float3 R = reflect(-V, N);
    float4 reflColor = texCube.SampleLevel(s0,R,0);

	float fresnel = ffresnel(dot(N, V), 0.3, 6);
	//float fresnel = texFresnel.SampleLevel(s0, float2 (dot(N, V),0),0).r;

	// wavelength colors
	const float4 colors[3] = {{ 1, 0, 0, 1 },{ 0, 1, 0, 1 },{ 0, 0, 1, 1 },	};
        
	// transmission
 	float4 transColor;
  	bool fail = false;
    for(int i=0; i<3; i++) {
    	float3 T = refract2(-V, N, etas[i], fail);
    	transColor += texCube.SampleLevel(s0, T,0)* colors[i];
	}

    return lerp(transColor*refractStrength, reflColor*reflectStrength*2, fresnel);
}

technique10 Template
{
	pass P0
	{
		SetVertexShader( CompileShader( vs_4_0, VS() ) );
		SetPixelShader( CompileShader( ps_4_0, PS() ) );
	}
}




